function z = m_times(x,y)
  if (isscalar(x) || isscalar(y))
      z = x .* y;
      return;
  end
  m = size(x,1);
  n = size(x,2);
%   if (n ~= size(y,1))
%       error('mmultmanual:size', 'matrix inner dimensions do not agree');
%   end
  p = size(y,2);
  z = zeros(m,p,class(x));

  %May be faster than bsxfun
  for rx=1:m
       for cy=1:p
         z(rx,cy)=sum(x(rx,:)'.*y(:,cy));
       end
  end
end